#!/bin/bash

# 
# script to run BRAMS on MPI/OMP mixed mode code at tupa
#
# usage: Xmit.sh TotMpi OmpMpi MpiNod
#    where:
#    TotMpi:  total number of MPI ranks
#    OmpMpi:  number of OpenMP threads per MPI rank
#    MpiNod:  number of MPI ranks per node
#

#
#
# script arguments
#
export TotMpi=$1
export OmpMpi=$2
export MpiNod=$3
export walltime=$4
export ccatt=$5
export RamsIn=$6
#export expname=$7

totMpiReal=$(($TotMpi-24))

#
# job name 
#
RunName=jules-brams
OutName=ccatt-reg${TotMpi}M${OmpMpi}O${MpiNod}CN
#
# directories
# executable full path
#
export DirBase=`pwd`
cd ${DirBase}
export executable=${DirBase}/${ccatt}


#
#xMit.sh <nProc> <nNodes> <nCores>
#xMit.sh 120 1 24
#xMit.sh 120 1 24
# starts producing queue script file qsub.sh
#

cat <<EOF0> qsub.sh
#!/bin/bash
#PBS -l mppwidth=${TotMpi}
#PBS -l mppdepth=${OmpMpi}
#PBS -l mppnppn=${MpiNod}
#PBS -N ${RunName}
#PBS -o ${DirBase}/saida.out
#PBS -e ${DirBase}/saida.err
#PBS -A CPTEC
#PBS -q pesq
#PBS -l walltime=${walltime}

cd ${DirBase}

export OMP_NUM_THREADS=${OmpMpi}
export TMPDIR=${DirBase}/tmp

#export MPICH_UNEX_BUFFER_SIZE=162914560

#export MPICH_PTL_UNEX_EVENTS=655360#327680 #163840
#export MPICH_MAX_SHORT_MSG_SIZE=1024
#export MPICH_FAST_MEMCPY=1

ulimit -s unlimited
ulimit -c unlimited

#sereal para um processador for makevfile/makesfc
time aprun -m 2Mhs -b -ss -n 1 -N 1 ${executable} -f ${RamsIn} > makevfile.log #SERIAL

#paralelo for INITIAL
#time aprun  -n 1 -N 1 ${executable} -f ${RamsIn} : -n ${totMpiReal} -d ${OmpMpi} -N ${MpiNod} ${executable} -f ${RamsIn} > initial.log #PARALEL0
#./xMit5.sh 24 1 24 00:30:00 jules3.0-ccatt-brams-5.0-opt.pgi-cray-RELACS_TUV RAMSIN
EOF0
#
# finishes producing file qsub.sh and moves to executable directory
#
#
# qsub with variable # PEs per node
#
export PBS_SERVER=eslogin13
qsub qsub.sh 

exit

